/**
 * Voorraadbeheer van 1 product.
 *
 * @author Dominiek Vandewalle
 * @version 2017-08-18
 */
public class Product
{
    private double prijs;//Prijs van het product.
    private int aantal;//Aantal items van dit product in voorraad.
    private String naam;//Naam van dit product.
    private char productKlasse;//A:premium, B:medium, C: huis
    private boolean bewaarInKoelcel;//Gekoeld bewaard?
 
    /**
     * Constructor voor objecten van Klasse Product.
     * @param   naam    De naam van het product.
     * @param   prijs   De prijs van dit product.
     * @param   klasse  De productklasse van het product.
     * @param   aantal  Het aantal items van het product.
     */
    public Product(String naam, double prijs, char klasse, int aantal)
    {
        this.naam = naam;
        this.prijs = prijs;
        this.aantal = aantal;
        productKlasse = klasse;
        bewaarInKoelcel = false;
    }

    /**
     * Geeft de naam van het product terug.
     * @return    De naaam van het product.
     */
    public String getNaam()
    {
        return naam;
    }
    
    /**
     * Geeft het aantal items in voorraad van het product.
     * @return    Aantal items in voorraad.
     */
    public int getAantal()
    {
        return aantal;
    }
        
    /**
     * Stelt de prijs in van het product.
     * @param   prijs   De nieuwe prijs van het product.
     */
    public void setPrijs(double prijs)
    {
        this.prijs = prijs;
    }
    
    /**
     * Het product toevoegen of verwijderen uit de koelcel.
     * @param  bewaarInKoelcel    True indien te bewaren in de koelcel, anders false.
     */
    public void setBewaarInKoelcel(boolean bewaarInKoelcel)
    {
        this.bewaarInKoelcel = bewaarInKoelcel;
    }
    
    /**
     * Berekent de prijs incl. BTW-bedrag van een aantal items van dit product.
     *
     * @param	aantal		Aantal items van dit product.
     * @param	btwTarief	Het BTW-tarief [0,1] van dit product.
     * @return	De prijs incl. BTW van een aantal items van dit product.
     */
    public double berekenPrijsBTW(int aantal, double btwTarief)
    {
        return (aantal * prijs * (1 + btwTarief));
    }
    
    /**
     * Berekent de nettowaarde van de voorraad van dit product.
     * @return    De nettowaarde van de voorraad van dit product.
     */
    public double berekenNettoVoorraadWaarde()
    {
        return aantal * prijs;
    }
}
